% ex8_71.m
% nonlinear model
% subsection 8.7.1
clear

N=50;
q=1;
r=1;
NN=N+1;
tt=0:N;
x=zeros(1,NN);
y=zeros(1,NN);
w=zeros(1,NN);
v=zeros(1,NN);
xef=zeros(1,NN);
parxef=zeros(1,NN);
w=sqrt(q)*randn(1,NN);
v=sqrt(r)*randn(1,NN);
x(1)=0;
t=0:N;
% Simulation
for k=1:N
    xx= 0.5*x(k)+25*x(k)/(1+x(k)*x(k))+ 8*cos(1.2*(k-1));
    x(k+1)=xx+w(k);
    y(k)=x(k)*x(k)/20+v(k);
end
y(N+1)=x(N+1)*x(N+1)/20+v(N+1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Extended Kalman filter
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xep=zeros(1,N+1);  % prediction xe_{t/t-1}
xef=zeros(1,N+1);  % filtering  xe_{t/t}
Pep=zeros(1,N+1);  % covariance of prediction P_{t/t-1}
Pef=zeros(1,N+1);  % covariance of filtering P_{t/t}
P0=2;
Pep(1,1)=P0;       % initial covariance of prediction
% k:=time index
hat=xep(1,1);
for k=1:N+1
% Filtering
H=hat/10;
K=Pep(1,k)*H/(H*Pep(1,k)*H+r);       % EKF gain
    hat2=hat + K*(y(k)-hat*hat/20); 
    xef(1,k)=hat2;
Pef(1,k)=r*Pep(1,k)/(H*Pep(1,k)*H+r);  % covariance of filtering
% Prediction
F=0.5+25*(1-hat2*hat2)/(1+hat2*hat2)^2;
Pep(1,k+1)=F*Pef(1,k)*F' + q;   % covarinace of prediction
hat=0.5*hat2+25*hat2/(1+hat2^2)+8*cos(1.2*(k-1));    % predicted estimate
xep(1,k+1)=hat;
end
ef=xef-x;
ef2=ef.*ef;
ef3=abs(ef);
ekf=sum(ef3)/N
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Particle filter
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
M = 100; % number of particles
parxef=zeros(1,NN);
x0=0;
P00=P0;
% Initialize the particle filter
for i=1:M
    xpartep(i) = x0 + sqrt(P00)*randn;
end
% k for time index
% i for particle index
for k=1:N+1 
for i=1:M
ypart=xpartep(i)^2/20;
nu(i)=y(k)-ypart;
alpha(i) = exp(-nu(i)^2/(2*r))/sqrt(2*pi*r);
end
% Normalization of the likelihood 
ss=sum(alpha);
for i=1:M
        alpha(i)=alpha(i)/ss;
end
% Resampling
c=rand;
    for j=1:M
        u = (j-c)/M; 
        usum = 0;
        for i=1:M
            usum = usum + alpha(i);
            if usum >= u
                xpart(j) = xpartep(i);
                break;
            end
        end
    end
% Filteres estimate
parxef(k)=mean(xpart);
% Prediction step
for i=1:M
wi= sqrt(q)*randn+8*cos(1.2*(k-1));   
xpartep(i)=0.5*xpart(i)+25*xpart(i)/(1+xpart(i)^2)+wi;
end
end % of index k
paref=parxef-x;
paref2=paref.*paref;
arE2=sum(paref2)/N;
paref3=abs(paref);
particle=sum(paref3)/N


p0=y(1,1:N+1);
p1=x(1,1:N+1);
p2=xef(1,1:N+1);
p3=parxef(1,1:N+1);

figure(1)
plot(t,p0,'gx-',t,p1,'r',t,p3,'bo-','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 8.6a: Filtering by PF')
axis([0,N,-30,30]);
grid
legend('Observation y_t','True x_t','Filtered estimate x_{t|t}')

figure(2)
plot(t,y(1,:),'gx-',t,x(1,:),'r',t,xef(1,:),'bo-','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 8.6b: Filtering by EKF')
axis([0,N,-30,30]);
grid
legend('Observation y_t','True x_t','Filtered estimate x_{t|t}')

figure(3)
plot(t,ef3,'b-',t,paref3,'r-','LineWidth',1.5)
axis([0 N 0 50])
xlabel('Number of steps t')
title('Fig. 8.7: Filtering error')
grid
legend('EKF','PF')
